//+------------------------------------------------------------------+
//|                                                  Smoothed_HA.mq4 |
//+------------------------------------------------------------------+
// https://forex-station.com/viewtopic.php?p=1295414114#p1295414114
// modified by banzai; July/4th/20
// thanks to mrtools codes/template
// not for sale, auction, rent, nor lease

#property copyright "www.forex-station.com"
#property link      "www.forex-station.com"

#property indicator_chart_window
#property indicator_buffers 4

enum LineStyleMenu
{
   DisplayHistogram,
   DisplayLine
};

//---- parameters
extern ENUM_MA_METHOD      MaMethod              = 1;
extern int                 MaPeriod              = 21;
extern ENUM_MA_METHOD      MaMethod2             = 1;
extern int                 MaPeriod2             = 8;

extern LineStyleMenu       DisplayStyle          = 0;
extern color               DownWickColor         = clrCrimson;
extern color               UpWickColor           = clrGreen;
extern color               BearBarColor          = clrRed;
extern color               BullBarColor          = clrLime;
extern int                 BearBarSize           = 4;
extern int                 BullBarSize           = 4;

extern bool                alertsOn              = true;
extern bool                alertsOnCurrent       = false;
extern bool                alertsMessage         = true;
extern bool                alertsSound           = false;
extern bool                alertsNotify          = false;
extern bool                alertsEmail           = false;
extern string              soundFile             = "alert2.wav";

//template code start1
extern string              button_note1          = "------------------------------";
extern ENUM_BASE_CORNER    btn_corner            = CORNER_LEFT_UPPER; // chart corner for anchoring
extern string              btn_text              = "HAS";
extern color               btn_text_color        = clrWhite;
extern color               btn_background_color  = clrDimGray;
extern int                 btn_Offset_x          = 20;                                     //btn__x
extern int                 btn_Offset_y          = 13;                                     //btn__y
extern int                 btn_Width             = 60;                                 //btn__width
extern int                 btn_Height            = 20;                                //btn__height
extern int                 btn_FontSize          = 10;                             //btn__font size
extern string              UniqueButtonID        = "HASmoothed2";
extern string              button_note2          = "------------------------------";
bool                       inpSelection          = false;                      // Highlight to move             
//template code end1

//---- buffers
double ExtMapBuffer1[], ExtMapBuffer2[], ExtMapBuffer3[], ExtMapBuffer4[], ExtMapBuffer5[], ExtMapBuffer6[], ExtMapBuffer7[], ExtMapBuffer8[], trend[];
//----
int ExtCountedBars=0;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//|------------------------------------------------------------------|
int OnInit()
  {
   IndicatorBuffers(8);
//template code start2
   if (ObjectFind(UniqueButtonID)!=0)
   {
         ObjectCreate    (ChartID(),UniqueButtonID,OBJ_BUTTON,         0,0,0);
         ObjectSetString (ChartID(),UniqueButtonID,OBJPROP_TEXT,       btn_text);
         ObjectSetInteger(ChartID(),UniqueButtonID,OBJPROP_FONTSIZE,   btn_FontSize);
         ObjectSetInteger(ChartID(),UniqueButtonID,OBJPROP_CORNER,     btn_corner);
         ObjectSetInteger(ChartID(),UniqueButtonID,OBJPROP_COLOR,      btn_text_color);
         ObjectSetInteger(ChartID(),UniqueButtonID,OBJPROP_BGCOLOR,    btn_background_color);
         ObjectSetInteger(ChartID(),UniqueButtonID,OBJPROP_YDISTANCE,  btn_Offset_y);
         ObjectSetInteger(ChartID(),UniqueButtonID,OBJPROP_XDISTANCE,  btn_Offset_x);
         ObjectSetInteger(ChartID(),UniqueButtonID,OBJPROP_XSIZE,      btn_Width);
         ObjectSetInteger(ChartID(),UniqueButtonID,OBJPROP_YSIZE,      btn_Height);
         ObjectSetInteger(ChartID(),UniqueButtonID,OBJPROP_SELECTABLE, inpSelection);
         ObjectSetInteger(ChartID(),UniqueButtonID,OBJPROP_SELECTED,   inpSelection);
         ObjectSetInteger(ChartID(),UniqueButtonID,OBJPROP_HIDDEN,     true);
         ObjectSetInteger(ChartID(),UniqueButtonID,OBJPROP_STATE,      true);
   }
         SetIndexBuffer(0, ExtMapBuffer1);
         SetIndexBuffer(1, ExtMapBuffer2);
         SetIndexBuffer(2, ExtMapBuffer3);
         SetIndexBuffer(3, ExtMapBuffer4);
         SetIndexBuffer(4, ExtMapBuffer5);
         SetIndexBuffer(5, ExtMapBuffer6);
         SetIndexBuffer(6, ExtMapBuffer7);
         SetIndexBuffer(7, ExtMapBuffer8);

   if (GetButtonState(UniqueButtonID)!="off")
   {
         if (DisplayStyle == 0)
            {
             SetIndexStyle (0, DRAW_HISTOGRAM, 0, 1, DownWickColor);
             SetIndexStyle (1, DRAW_HISTOGRAM, 0, 1, UpWickColor);
             SetIndexStyle (2, DRAW_HISTOGRAM, 0, BearBarSize, BearBarColor);
             SetIndexStyle (3, DRAW_HISTOGRAM, 0, BullBarSize, BullBarColor);           
            }
         else
            {
             SetIndexStyle (0, DRAW_NONE, 0, 1, DownWickColor);
             SetIndexStyle (1, DRAW_NONE, 0, 1, UpWickColor);
             SetIndexStyle (2, DRAW_LINE, 0, BearBarSize, BearBarColor);
             SetIndexStyle (3, DRAW_LINE, 0, BullBarSize, BullBarColor);
            }
    }
    else for (int i=0; i<3; i++) SetIndexStyle(i,DRAW_NONE);
//template code end2

   return(0);
  }
//+------------------------------------------------------------------+
//template code start3
void OnDeinit(const int reason)
{
      switch(reason)
      {
         case REASON_PARAMETERS  :
         case REASON_CHARTCHANGE :
         case REASON_RECOMPILE   :
         case REASON_CLOSE       : break;
         default                 : ObjectDelete(UniqueButtonID);
      }
}
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long& lparam, const double& dparam, const string& sparam)
{
   static string prevState ="";
   if (id==CHARTEVENT_OBJECT_CLICK && sparam==UniqueButtonID)
   {
         string newState = GetButtonState(UniqueButtonID);
         if (newState!=prevState)
         if (newState=="off")
         { 
           SetIndexStyle(0, DRAW_NONE); 
           SetIndexStyle(1, DRAW_NONE); 
           SetIndexStyle(2, DRAW_NONE); 
           SetIndexStyle(3, DRAW_NONE); 
           prevState=newState; 
         }
         else  // on state
         { 
         if (DisplayStyle == 0)
            {
             SetIndexStyle (0, DRAW_HISTOGRAM, 0, 1, DownWickColor);
             SetIndexStyle (1, DRAW_HISTOGRAM, 0, 1, UpWickColor);
             SetIndexStyle (2, DRAW_HISTOGRAM, 0, BearBarSize, BearBarColor);
             SetIndexStyle (3, DRAW_HISTOGRAM, 0, BullBarSize, BullBarColor);           
            }
         else
            {
             SetIndexStyle (0, DRAW_NONE, 0, 1, DownWickColor);
             SetIndexStyle (1, DRAW_NONE, 0, 1, UpWickColor);
             SetIndexStyle (2, DRAW_LINE, 0, BearBarSize, BearBarColor);
             SetIndexStyle (3, DRAW_LINE, 0, BullBarSize, BullBarColor);
            }
           prevState=newState; 
         }
         ObjectSetString(ChartID(),UniqueButtonID,OBJPROP_TEXT,btn_text);
   }
}  
//+------------------------------------------------------------------+
string GetButtonState(string whichbutton)
{
      bool selected = ObjectGetInteger(ChartID(),whichbutton,OBJPROP_STATE);
      if (selected) { return ("on");  } 
      else          { return ("off"); }
}
//template code end3
//+------------------------------------------------------------------+
int start()
  {
   int counted_bars=IndicatorCounted();
   int limit;

   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
         limit = MathMin(Bars-counted_bars,Bars-1);
   
   //
   //
   //
   //
   //
   
   for (int pos=limit; pos >= 0; pos--)
   {  
      double maOpen  = iMA(NULL,0,MaPeriod,0,MaMethod,PRICE_OPEN ,pos);
      double maClose = iMA(NULL,0,MaPeriod,0,MaMethod,PRICE_CLOSE,pos);
      double maLow   = iMA(NULL,0,MaPeriod,0,MaMethod,PRICE_LOW  ,pos);
      double maHigh  = iMA(NULL,0,MaPeriod,0,MaMethod,PRICE_HIGH ,pos);

      double haOpen  = (ExtMapBuffer5[pos+1]+ExtMapBuffer6[pos+1])/2;
      double haClose = (maOpen+maHigh+maLow+maClose)/4;
      double haHigh  = MathMax(maHigh, MathMax(haOpen, haClose));
      double haLow   = MathMin(maLow, MathMin(haOpen, haClose));

      if (haOpen<haClose) { ExtMapBuffer7[pos]=haLow;  ExtMapBuffer8[pos]=haHigh;} 
      else                { ExtMapBuffer7[pos]=haHigh; ExtMapBuffer8[pos]=haLow; } 
      ExtMapBuffer5[pos]=haOpen;
      ExtMapBuffer6[pos]=haClose;

     }

     for (pos=limit; pos >= 0; pos--)
     {
        ExtMapBuffer1[pos]=iMAOnArray(ExtMapBuffer7,0,MaPeriod2,0,MaMethod2,pos);
        ExtMapBuffer2[pos]=iMAOnArray(ExtMapBuffer8,0,MaPeriod2,0,MaMethod2,pos);
        ExtMapBuffer3[pos]=iMAOnArray(ExtMapBuffer5,0,MaPeriod2,0,MaMethod2,pos);
        ExtMapBuffer4[pos]=iMAOnArray(ExtMapBuffer6,0,MaPeriod2,0,MaMethod2,pos);
        trend[pos] = trend[pos+1];
           if (ExtMapBuffer3[pos]<ExtMapBuffer4[pos]) trend[pos] = 1;
           if (ExtMapBuffer3[pos]>ExtMapBuffer4[pos]) trend[pos] =-1;
     }
     
     if (alertsOn)
     {
        int whichBar = 1; if (alertsOnCurrent) whichBar = 0;
        if (trend[whichBar] != trend[whichBar+1])
        if (trend[whichBar] == 1)
              doAlert("up");
        else  doAlert("down");       
     }       

   return(0);
  }
//+------------------------------------------------------------------+
void doAlert(string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[0]) {
          previousAlert  = doWhat;
          previousTime   = Time[0];

          //
          //
          //
          //
          //
          
          message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," Heiken_Ashi_Smoothed ",doWhat);
             if (alertsMessage) Alert(message);
             if (alertsNotify)  SendNotification(message);
             if (alertsEmail)   SendMail(StringConcatenate(Symbol()," Heiken_Ashi_Smoothed "),message);
             if (alertsSound)   PlaySound(soundFile);
      }
}
//+------------------------------------------------------------------+
